
rem
bbdoc: allows single stepping
end rem
Type TDemoTestScreen Extends TScreen
	
	Field agent:TAgent
	Field border:TBorder
	
	Field boxTexture:TImage
	Field bodyList:TList = CreateList()
	Field geomList:TList = CreateList()
	
	Field body1:TBody
	Field body2:TBody
	Field body3:TBody
	Field body4:TBody
	Field body5:TBody
	Field body6:TBody
	Field body7:TBody
	Field body8:TBody
	
	Field geom1:TGeom
	Field geom2:TGeom
	Field geom3:TGeom
	Field geom4:TGeom
	Field geom5:TGeom
	Field geom6:TGeom
	Field geom7:TGeom
	Field geom8:TGeom
	
	Field interactiveJoint:TInteractiveAngleJoint
	
	Method Draw(delta:Float)
		
		border.Draw()
		agent.Draw()		
		TDrawingHelper.DrawGeom(geom1, boxTexture)
		TDrawingHelper.DrawGeom(geom2, boxTexture)
		TDrawingHelper.DrawGeom(geom3, boxTexture)
		TDrawingHelper.DrawGeom(geom4, boxtexture)
		TDrawingHelper.DrawGeom(geom5, boxtexture)
		TDrawingHelper.DrawGeom(geom6, boxtexture)
		TDrawingHelper.DrawGeom(geom7, boxtexture)
		TDrawingHelper.DrawGeom(geom8, boxtexture)
		For Local geom:TGeom = EachIn geomlist
			TDrawingHelper.DrawGeom(geom, boxTexture)
		Next
		If physics.EnableDiagnostics Then
			view.Draw()
		End If
		DrawMouseSpring()
	End Method
	
	Field _firstRun:Int = True
	Method Update(delta:Float)
		If _firstRun Then
			 ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails()))
			_firstRun = False
		EndIf
		HandleMouseInput()
		HandleKeyboardInput()
	'	interactivejoint.CalculateJoint(MouseX(), MouseY())
		physics.Update(delta)

	End Method
	
	
	Method HandleKeyboardInput()
		Local forceAmount:Float = 3000
		Local force:Vector2 = Vector2.Zero() 
		
		If KeyDown(KEY_A) Then force.X:+- forceAmount
		If KeyDown(KEY_S) Then force.Y:+forceAmount
		If KeyDown(KEY_D) Then force.X:+forceAmount
		If KeyDown(KEY_W) Then force.Y:+- forceAmount
		agent.agentBody.ApplyForce(force) 
		
		Local torqueAmount:Float = 14000
		Local torque:Float = 0
		If KeyDown(KEY_LEFT) Then torque:-torqueAmount
		If KeyDown(KEY_RIGHT) Then torque:+torqueAmount
		agent.agentBody.ApplyTorque(torque) 
		
		If KeyHit(KEY_F1) Then
			physics.EnableDiagnostics = Not physics.EnableDiagnostics
		End If
	End Method
	
	Method Load()
		physics = TPhysicsSimulator.Create(Vector2.Create(0, 150))
		physics.SetMaxContactsToDetect(5)
		physics.SetMaxContactsToResolve(2)
	'	physics.SetBroadPhaseCollider(TBruteForceCollider.Create(physics))
	'	physics.SetBroadPhaseCollider(TSweepAndPruneCollider.Create(physics))
		physics.SetIterations(10) 
		physics.SetBiasFactor(.4)
		view = TPhysicsSimulatorView.Create(physics)
		view.EnableVerticeView(False)
		
			
		Local center:Vector2 = Vector2.Create(TDemo.gfxWidth / 2.0, TDemo.gfxHeight / 2.0)
		Local borderWidth:Int = TDemo.gfxHeight *.05
		border = TBorder.Create(TDemo.gfxWidth, TDemo.gfxHeight, borderWidth, center)
		border.Load(physics)
		
		agent = TAgent.Create(Vector2.Create(center.X - 200, center.Y)) 
		agent._collisionCategories = CollisionCategories.Cat5
		agent._collidesWith = CollisionCategories.All & ~COllisionCategories.Cat4
		agent.Load(physics)
		agent.agentBody.SetLinearDragCoefficient(.001)
		
		LoadObjects()
		 
	End Method
	

	Method LoadObjects()
		Local boxWidth:Int = 70
		Local boxHeight:Int = 20
		boxTexture = TDrawingHelper.CreateRectangleTexture(boxWidth, boxHeight, TColor.White, TColor.Black)
		MidHandleImage(boxtexture)
		body1 = TBodyFactory.CreateRectangleBody(physics, boxWidth, boxHeight, 1)
		body2 = TBodyFactory.CreateRectangleBody(physics, boxWidth, boxHeight, 1)
		body1.SetPosition(Vector2.Create(400, 200))
		body2.SetPosition(Vector2.Create(400 + boxWidth + 4, 200))
		
		body3 = TBodyFactory.CreateRectangleBody(physics, boxWidth, boxHeight, 1)
		body3.SetPosition(Vector2.Create(600, 200))
		
		body4 = TBodyFactory.CreateRectangleBody(physics, boxWidth, boxHeight, 1)
		body4.SetPosition(Vector2.Create(700, 200))
		
		body5 = TBodyFactory.CreateRectangleBody(physics, boxWidth, boxHeight, 1)
		body5.SetPosition(Vector2.Create(500, 500))
		
		body6 = TBodyFactory.CreateRectangleBody(physics, boxWidth, boxHeight, 1)
		body6.SetPosition(Vector2.Create(430, 500))

		body7 = TBodyFactory.CreateRectangleBody(physics, boxWidth, boxHeight, 1)
		body8 = TBodyFactory.CreateRectangleBody(physics, boxWidth, boxHeight, 1)
		body7.SetPosition(Vector2.Create(200, 500))
		body8.SetPosition(Vector2.Create(270, 500))
		
		Local body9:TBody = TBodyFactory.CreateRectangleBody(physics, boxWidth, boxHeight, 1)
		Local body10:TBody = TBodyFactory.CreateRectangleBody(physics, boxWidth, boxHeight, 1)
		bodyList.AddLast(body9)
		bodyList.AddLast(body10)
		body9.SetPosition(Vector2.Create(200, 600))
		body10.SetPosition(Vector2.Create(570, 600))
		
		Local body11:TBody = TBodyFactory.CreateRectangleBody(physics, boxWidth, boxHeight, 1)
		Local body12:TBody = TBodyFactory.CreateRectangleBody(physics, boxWidth, boxHeight, 1)
		body11.SetPosition(Vector2.Create(700, 600))
		body12.SetPosition(Vector2.Create(700, 570))
		bodylist.AddLast(body11)
		bodylist.AddLast(body12)
		
		geom1 = TGeomFactory.CreateRectangleGeom(physics, body1, boxWidth, boxHeight)
		geom2 = TGeomFactory.CreateRectangleGeom(physics, body2, boxWidth, Boxheight)		
		geom1.SetCollisionGroup(340)
		geom2.SetCollisionGroup(340)
		
		geom3 = TGeomFactory.CreateRectangleGeom(physics, body3, boxWidth, boxHeight)
		geom4 = TGeomFactory.CreateRectangleGeom(physics, body4, boxWidth, boxHeight)
		geom5 = TGeomFactory.CreateRectangleGeom(physics, body5, boxWidth, boxHeight)
		geom6 = TGeomFactory.CreateRectangleGeom(physics, body6, boxWidth, boxHeight)
		geom5.SetCollisionGroup(350)
		geom6.SetCollisionGroup(350)
		
		geom7 = TGeomFactory.CreateRectangleGeom(physics, body7, boxWidth, boxheight)
		geom8 = TGeomFactory.CreateRectangleGeom(physics, body8, boxWidth, boxHeight)
		geom7.SetCollisionGroup(260)
		geom8.SetCollisionGroup(260)
		
		Local geom9:TGeom = TGeomFactory.CreateRectangleGeom(physics, body9, boxWidth, boxHeight)
		Local geom10:TGeom = TGeomFactory.CreateRectangleGeom(physics, body10, boxWidth, boxHeight)
		geomList.AddLast(geom9)
		geomList.AddLast(geom10)
		geom9.SetCollisionGroup(555)
		geom10.SetCollisionGroup(555)
		
		Local geom11:TGeom = TGeomFactory.CreateRectangleGeom(physics, body11, boxWidth, boxHeight)
		Local geom12:TGeom = TGeomFactory.CreateRectangleGeom(physics, body12, boxWidth, boxHeight)
		geom11.SetCollisionGroup(343)
		geom12.SetCollisionGroup(343)
		geomlist.AddLast(geom11)
		geomlist.AddLast(geom12)
		
		' nun-chucks
		TJointFactory.CreateAngleLimitJoint(physics, body1, body2, 0, Pi + pi/2)
		TJointFactory.CreateRevoluteJoint(physics, body1, body2, Vector2.Create(body1._position.x + boxWidth / 2, body1._position.Y))
		
		' fixed angle limit joint
		TJointFactory.CreateFixedRevoluteJoint(physics, body3, Vector2.Create(body3._position.x - boxWidth / 2, body3._position.y))
		TJointFactory.CreateFixedAngleLimitJoint(physics, body3, 0, Pi)
		
		' fixed angle joint
		TJointFactory.CreateFixedAngleJoint(physics, body4, Pi / 4)
		
		' angle spring setup
		Local spring:TAngleSpring = TControllerFactory.CreateAngleSpring(physics, body5, body6, 100000, 5000)
		spring.SetTargetAngle(MathHelper.ToRadians(180 + 45))
		TJointFactory.CreateRevoluteJoint(physics, body5, body6, Vector2.Create(500 - 35, 500))
		
		' interactiveJoint
		interactiveJoint = TJointFactory.CreateInteractiveAngleJoint(physics, 0, Pi / 2, Pi, Pi + Pi / 2, - Pi, 2 * Pi, 0, Vector2.Create(235, 500), body7, body8)
		
		'pin joint
		TJointFactory.CreatePinJoint(physics, body9, Vector2.Zero(), body10, Vector2.Zero())
		
		'slider joint
		TJointFactory.CreateSliderJoint(physics, body11, Vector2.Zero(), body12, Vector2.Zero(), 50, 200)
		
	End Method
	
	Method Unload()
		
	End Method
	
	Method OnEscapeKeyHit()
		ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails()))
	End Method
	
	Method GetTitle:String()
		Return "Angle Limit"
	End Method
	
	Method GetDetails:TStringBuilder()
		Return new TStringBuilder
	End Method
End Type
